<?php
session_start();
include '../config.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Popunder settings
    $popunder_enabled = isset($_POST['popunder_enabled']) ? 1 : 0;
    $popunder_url = mysqli_real_escape_string($conn, $_POST['popunder_url']);
    $popunder_delay = (int)$_POST['popunder_delay'];
    
    // Redirect settings
    $redirect_enabled = isset($_POST['redirect_enabled']) ? 1 : 0;
    $redirect_url = mysqli_real_escape_string($conn, $_POST['redirect_url']);
    
    // Banner settings
    $banner_enabled = isset($_POST['banner_enabled']) ? 1 : 0;
    $banner_codes = mysqli_real_escape_string($conn, $_POST['banner_codes']);
    
    // Random button settings
    $random_button_enabled = isset($_POST['random_button_enabled']) ? 1 : 0;
    $random_button_text = mysqli_real_escape_string($conn, $_POST['random_button_text']);
    
    $query = "UPDATE ads_settings SET 
              popunder_enabled = $popunder_enabled,
              popunder_url = '$popunder_url',
              popunder_delay = $popunder_delay,
              redirect_enabled = $redirect_enabled,
              redirect_url = '$redirect_url',
              banner_enabled = $banner_enabled,
              banner_codes = '$banner_codes',
              random_button_enabled = $random_button_enabled,
              random_button_text = '$random_button_text'
              WHERE id = 1";
    
    if (mysqli_query($conn, $query)) {
        $success = "Configuración de anuncios actualizada correctamente";
    } else {
        $error = "Error al actualizar la configuración";
    }
}

$query = "SELECT * FROM ads_settings WHERE id = 1";
$result = mysqli_query($conn, $query);
$ads = mysqli_fetch_assoc($result);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuración de Anuncios - Free and Simple Video Hosting</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .ads-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        .ads-card:hover {
            transform: translateY(-5px);
        }
        .ads-header {
            background: linear-gradient(135deg, #6e8efb, #a777e3);
            color: white;
            padding: 2rem;
            border-radius: 15px 15px 0 0;
            text-align: center;
        }
        .ads-icon {
            font-size: 4rem;
            margin-bottom: 1rem;
        }
        .form-control {
            border-radius: 10px;
            padding: 0.75rem 1rem;
            border: 1px solid #e0e0e0;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            box-shadow: 0 0 0 3px rgba(110, 142, 251, 0.2);
            border-color: #6e8efb;
        }
        .btn-save {
            background: linear-gradient(135deg, #6e8efb, #a777e3);
            border: none;
            border-radius: 10px;
            padding: 0.75rem 2rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-save:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(110, 142, 251, 0.4);
        }
        .form-switch .form-check-input {
            width: 3em;
            height: 1.5em;
            margin-left: -3.5em;
        }
        .form-switch .form-check-input:checked {
            background-color: #6e8efb;
            border-color: #6e8efb;
        }
        .section-title {
            color: #444;
            border-bottom: 2px solid #eee;
            padding-bottom: 0.5rem;
            margin-bottom: 1.5rem;
        }
    </style>
</head>
<body class="bg-light">
    <?php include 'navbar.php'; ?>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="ads-card">
                    <div class="ads-header">
                        <i class="fas fa-ad ads-icon"></i>
                        <h2 class="mb-0">Configuración de Anuncios</h2>
                        <p class="mb-0">Gestiona los anuncios de tu sitio</p>
                    </div>
                    
                    <div class="card-body p-4">
                        <?php if (isset($success)): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></i><?php echo $success; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-circle me-2"></i><?php echo $error; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <!-- Random Button Settings -->
                            <h4 class="section-title">
                                <i class="fas fa-random me-2"></i>Botón de Video Aleatorio
                            </h4>
                            <div class="mb-4">
                                <div class="form-check form-switch mb-3">
                                    <input type="checkbox" class="form-check-input" id="random_button_enabled" 
                                           name="random_button_enabled" <?php echo $ads['random_button_enabled'] ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="random_button_enabled">Activar Botón de Video Aleatorio</label>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Texto del Botón</label>
                                    <input type="text" name="random_button_text" class="form-control" 
                                           value="<?php echo htmlspecialchars($ads['random_button_text']); ?>"
                                           placeholder="MIRA MAS VIDEOS AQUI">
                                </div>
                            </div>

                            <!-- Popunder Settings -->
                            <h4 class="section-title">
                                <i class="fas fa-window-restore me-2"></i>Anuncio Popunder
                            </h4>
                            <div class="mb-4">
                                <div class="form-check form-switch mb-3">
                                    <input type="checkbox" class="form-check-input" id="popunder_enabled" 
                                           name="popunder_enabled" <?php echo $ads['popunder_enabled'] ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="popunder_enabled">Activar Popunder</label>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">URL del Popunder</label>
                                    <input type="url" name="popunder_url" class="form-control" 
                                           value="<?php echo htmlspecialchars($ads['popunder_url']); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Retraso (segundos)</label>
                                    <input type="number" name="popunder_delay" class="form-control" 
                                           value="<?php echo $ads['popunder_delay']; ?>" min="0">
                                </div>
                            </div>

                            <!-- Redirect Settings -->
                            <h4 class="section-title">
                                <i class="fas fa-external-link-alt me-2"></i>Redirección al Finalizar
                            </h4>
                            <div class="mb-4">
                                <div class="form-check form-switch mb-3">
                                    <input type="checkbox" class="form-check-input" id="redirect_enabled" 
                                           name="redirect_enabled" <?php echo $ads['redirect_enabled'] ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="redirect_enabled">Activar Redirección</label>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">URL de Redirección</label>
                                    <input type="url" name="redirect_url" class="form-control" 
                                           value="<?php echo htmlspecialchars($ads['redirect_url']); ?>">
                                </div>
                            </div>

                            <!-- Banner Settings -->
                            <h4 class="section-title">
                                <i class="fas fa-image me-2"></i>Banner Publicitario
                            </h4>
                            <div class="mb-4">
                                <div class="form-check form-switch mb-3">
                                    <input type="checkbox" class="form-check-input" id="banner_enabled" 
                                           name="banner_enabled" <?php echo $ads['banner_enabled'] ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="banner_enabled">Activar Banner</label>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Códigos del Banner</label>
                                    <textarea name="banner_codes" class="form-control" rows="6" 
                                              placeholder="Ingresa los códigos HTML, JS, PHP, etc."><?php echo htmlspecialchars($ads['banner_codes']); ?></textarea>
                                    <small class="text-muted">
                                        <i class="fas fa-info-circle me-1"></i>
                                        Puedes insertar cualquier tipo de código (HTML, JavaScript, PHP, etc.)
                                    </small>
                                </div>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-save btn-primary">
                                    <i class="fas fa-save me-2"></i>Guardar Cambios
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>