<?php
session_start();
include '../config.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $site_name = mysqli_real_escape_string($conn, $_POST['site_name']);
    $site_description = mysqli_real_escape_string($conn, $_POST['site_description']);
    $favicon_url = mysqli_real_escape_string($conn, $_POST['favicon_url']);
    $counter_code = mysqli_real_escape_string($conn, $_POST['counter_code']);
    
    $query = "UPDATE settings SET 
              site_name = '$site_name',
              site_description = '$site_description',
              favicon_url = '$favicon_url',
              counter_code = '$counter_code'
              WHERE id = 1";
    
    if (mysqli_query($conn, $query)) {
        $success = "Configuración actualizada correctamente";
    } else {
        $error = "Error al actualizar la configuración";
    }
}

$query = "SELECT * FROM settings WHERE id = 1";
$result = mysqli_query($conn, $query);
$settings = mysqli_fetch_assoc($result);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuración - Free and Simple Video Hosting</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .settings-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        .settings-card:hover {
            transform: translateY(-5px);
        }
        .settings-header {
            background: linear-gradient(135deg, #6e8efb, #a777e3);
            color: white;
            padding: 2rem;
            border-radius: 15px 15px 0 0;
            text-align: center;
        }
        .settings-icon {
            font-size: 4rem;
            margin-bottom: 1rem;
        }
        .form-control {
            border-radius: 10px;
            padding: 0.75rem 1rem;
            border: 1px solid #e0e0e0;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            box-shadow: 0 0 0 3px rgba(110, 142, 251, 0.2);
            border-color: #6e8efb;
        }
        .btn-save {
            background: linear-gradient(135deg, #6e8efb, #a777e3);
            border: none;
            border-radius: 10px;
            padding: 0.75rem 2rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-save:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(110, 142, 251, 0.4);
        }
        .input-group-text {
            background: transparent;
            border-right: none;
        }
        .input-group .form-control {
            border-left: none;
        }
        .alert {
            border-radius: 10px;
            border: none;
        }
        .alert-success {
            background: rgba(25, 135, 84, 0.1);
            color: #198754;
        }
        .alert-danger {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
        }
        .form-label {
            font-weight: 500;
            color: #444;
            margin-bottom: 0.5rem;
        }
    </style>
</head>
<body class="bg-light">
    <?php include 'navbar.php'; ?>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="settings-card">
                    <div class="settings-header">
                        <i class="fas fa-cog settings-icon"></i>
                        <h2 class="mb-0">Configuración del Sitio</h2>
                        <p class="mb-0">Personaliza la apariencia y funcionamiento de tu sitio</p>
                    </div>
                    
                    <div class="card-body p-4">
                        <?php if (isset($success)): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></i><?php echo $success; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-circle me-2"></i><?php echo $error; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <div class="mb-4">
                                <label class="form-label">
                                    <i class="fas fa-heading me-2"></i>Nombre del Sitio
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text border-end-0">
                                        <i class="fas fa-globe text-muted"></i>
                                    </span>
                                    <input type="text" name="site_name" class="form-control border-start-0" 
                                           value="<?php echo htmlspecialchars($settings['site_name']); ?>" required>
                                </div>
                            </div>
                            <div class="mb-4">
                                <label class="form-label">
                                    <i class="fas fa-align-left me-2"></i>Descripción del Sitio
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text border-end-0">
                                        <i class="fas fa-comment text-muted"></i>
                                    </span>
                                    <textarea name="site_description" class="form-control border-start-0" 
                                              rows="3" required><?php echo htmlspecialchars($settings['site_description']); ?></textarea>
                                </div>
                            </div>
                            <div class="mb-4">
                                <label class="form-label">
                                    <i class="fas fa-image me-2"></i>URL del Favicon
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text border-end-0">
                                        <i class="fas fa-link text-muted"></i>
                                    </span>
                                    <input type="url" name="favicon_url" class="form-control border-start-0" 
                                           value="<?php echo htmlspecialchars($settings['favicon_url']); ?>">
                                </div>
                                <small class="text-muted mt-2">
                                    <i class="fas fa-info-circle me-1"></i>Deja en blanco para usar el favicon por defecto
                                </small>
                            </div>
                            <div class="mb-4">
                                <label class="form-label">
                                    <i class="fas fa-chart-line me-2"></i>Código del Contador de Visitas
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text border-end-0">
                                        <i class="fas fa-code text-muted"></i>
                                    </span>
                                    <textarea name="counter_code" class="form-control border-start-0" 
                                              rows="4"><?php echo htmlspecialchars($settings['counter_code']); ?></textarea>
                                </div>
                                <small class="text-muted mt-2">
                                    <i class="fas fa-info-circle me-1"></i>Pega aquí el código del contador de visitas
                                </small>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-save btn-primary">
                                    <i class="fas fa-save me-2"></i>Guardar Cambios
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>